/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.BlockCategories;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class ObserverSwitchBlock
extends SwitchBlock {
    public ObserverSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (!this.isAffectedByNeigbour(state, world, pos, facingPos)) {
            return state;
        }
        ObserverSwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (te != null) {
            te.observe();
        }
        return state;
    }

    @Override
    public ObserverSwitchTileEntity getTe(LevelReader world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof ObserverSwitchTileEntity)) {
            return null;
        }
        return (ObserverSwitchTileEntity)te;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ObserverSwitchTileEntity(pos, state);
    }

    public static class ObserverSwitchTileEntity
    extends SwitchBlock.SwitchTileEntity {
        public final int debounce_max = 10;
        public final int range_max = 8;
        public final int threshold_max = 8;
        private int debounce_ = 0;
        private int range_ = 0;
        private int threshold_ = 1;
        private int filter_index_ = 0;
        private int update_timer_ = 0;
        private int debounce_counter_ = 0;

        public ObserverSwitchTileEntity(BlockEntityType<?> te_type, BlockPos pos, BlockState state) {
            super(te_type, pos, state);
        }

        public ObserverSwitchTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_OBSERVER_SWITCH, pos, state);
        }

        int debounce() {
            return this.debounce_;
        }

        int range() {
            return this.range_;
        }

        int threshold() {
            return this.threshold_;
        }

        int filter() {
            return this.filter_index_;
        }

        String filter_name() {
            return BlockCategories.getMatcherNames().get(this.filter_index_ < 0 ? 0 : (this.filter_index_ >= BlockCategories.getMatcherNames().size() ? BlockCategories.getMatcherNames().size() - 1 : this.filter_index_));
        }

        void filter_name(String name) {
            int i = -1;
            int fi = 0;
            for (String s : BlockCategories.getMatcherNames()) {
                ++i;
                if (!s.equals(name)) continue;
                fi = i;
                break;
            }
            this.filter_index_ = fi;
        }

        void debounce(int i) {
            this.debounce_ = i <= 0 ? 0 : Math.min(i, 10);
        }

        void range(int i) {
            this.range_ = i <= 0 ? 0 : Math.min(i, 8);
        }

        void threshold(int i) {
            this.threshold_ = i <= 0 ? 0 : Math.min(i, 8);
        }

        void filter(int f) {
            this.filter_index_ = f >= BlockCategories.getMatcherNames().size() ? BlockCategories.getMatcherNames().size() - 1 : Math.max(f, 0);
        }

        @Override
        public void write(CompoundTag nbt, boolean updatePacket) {
            super.write(nbt, updatePacket);
            nbt.m_128405_("range", this.range_);
            nbt.m_128405_("threshold", this.threshold_);
            nbt.m_128359_("filter", this.filter_name());
            nbt.m_128405_("debounce", this.debounce_);
        }

        @Override
        public void read(CompoundTag nbt, boolean updatePacket) {
            super.read(nbt, updatePacket);
            this.range(nbt.m_128451_("range"));
            this.threshold(nbt.m_128451_("threshold"));
            this.filter_name(nbt.m_128461_("filter"));
            this.debounce(nbt.m_128451_("debounce"));
        }

        @Override
        public void reset(@Nullable LevelReader world) {
            super.reset(world);
            this.filter_index_ = 0;
            this.range_ = 0;
            this.threshold_ = 1;
            this.debounce_ = 0;
            this.update_timer_ = 0;
            this.debounce_counter_ = 0;
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable Player player, double x, double y, boolean show_only) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            int n = y >= 12.0 && y <= 13.0 ? 1 : (direction = y >= 9.0 && y <= 10.0 ? -1 : 0);
            int n2 = x >= 1.0 && x <= 2.0 ? 1 : (x >= 4.0 && x <= 5.0 ? 2 : (x >= 7.0 && x <= 8.0 ? 3 : (x >= 10.0 && x <= 11.0 ? 4 : (field = x >= 13.0 && x <= 14.0 ? 5 : 0))));
            if (direction == 0 || field == 0) {
                return false;
            }
            if (!show_only) {
                switch (field) {
                    case 1: {
                        this.range(this.range() + direction);
                        if (this.threshold() <= this.range()) break;
                        this.threshold(this.range());
                        break;
                    }
                    case 2: {
                        this.threshold(this.threshold() + direction);
                        break;
                    }
                    case 3: {
                        this.debounce(this.debounce() + direction);
                        break;
                    }
                    case 4: {
                        this.setpower(this.setpower() + direction);
                        break;
                    }
                    case 5: {
                        this.filter(this.filter() + direction);
                    }
                }
                if (this.threshold() < 1) {
                    this.threshold(1);
                }
                if (this.setpower() < 1) {
                    this.setpower(1);
                }
                this.update_timer_ = 0;
                this.m_6596_();
            }
            ArrayList<Object> tr = new ArrayList<Object>();
            TextComponent separator = new TextComponent(" | ");
            separator.m_130940_(ChatFormatting.GRAY);
            tr.add(Auxiliaries.localizable("switchconfig.blocksensor.range", ChatFormatting.BLUE, new Object[]{this.range()}));
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.blocksensor.threshold", ChatFormatting.YELLOW, new Object[]{this.threshold()})));
            if (this.debounce() > 0) {
                tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.lightsensor.debounce", ChatFormatting.AQUA, new Object[]{this.debounce()})));
            } else {
                tr.add(new TextComponent(""));
            }
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.blocksensor.output_power", ChatFormatting.RED, new Object[]{this.setpower()})));
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.blocksensor.filter", ChatFormatting.DARK_GREEN, new Object[]{new TranslatableComponent("rsgauges.switchconfig.blocksensor.filter." + this.filter_name())})));
            Overlay.show(player, (Component)Auxiliaries.localizable("switchconfig.blocksensor", ChatFormatting.RESET, tr.toArray()));
            return !show_only;
        }

        public void observe() {
            if (this.update_timer_ > 2) {
                this.update_timer_ = 0;
            }
        }

        @Override
        public void tick() {
            boolean active;
            BlockPos p;
            Block block;
            if (this.f_58857_.m_5776_() || --this.update_timer_ > 0) {
                return;
            }
            this.update_timer_ = (this.range_ <= 1 ? 20 : 10) + (int)(Math.random() * 3.0);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (state == null || !((block = state.m_60734_()) instanceof ObserverSwitchBlock)) {
                return;
            }
            ObserverSwitchBlock block2 = (ObserverSwitchBlock)block;
            Direction obervationDirection = (Direction)state.m_61143_((Property)RsDirectedBlock.FACING);
            int n_matched = 0;
            int rng = this.range_ < 2 ? 1 : this.range_;
            int tr = Math.min(this.threshold_, rng);
            String fname = this.filter_name();
            BlockCategories.Matcher matcher = BlockCategories.getMatcher(fname);
            for (int n = 1; !(n > rng || this.f_58857_.isAreaLoaded(p = this.f_58858_.m_5484_(obervationDirection, n), 1) && matcher.match(this.f_58857_, p) && ++n_matched >= tr); ++n) {
            }
            boolean bl = active = n_matched >= this.threshold_;
            if (this.debounce_ > 0) {
                if (active) {
                    if (++this.debounce_counter_ < this.debounce_) {
                        return;
                    }
                    this.debounce_counter_ = this.debounce_;
                    active = true;
                } else {
                    if (--this.debounce_counter_ > 0) {
                        return;
                    }
                    this.debounce_counter_ = 0;
                    active = false;
                }
            }
            if ((Boolean)state.m_61143_((Property)SwitchBlock.POWERED) != active) {
                block2.onSwitchActivated(this.f_58857_, this.f_58858_, state, null, null);
            }
        }
    }
}

